//
//  GSClass.h
//  GlyphsCore
//
//  Created by Georg Seifert on 25.10.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;

@interface GSClass : NSObject <NSCoding, NSCopying> {
	GSFont * parent;
	NSString * _name;
	NSString * _code;
	BOOL _automatic;
	NSString * _notes;
}
@property (nonatomic, assign) GSFont *parent;
@property(copy, nonatomic) NSString * name;
//! The feature representation on FDK syntax.
@property(retain, nonatomic) NSString * code;
//! if the class is replaced on automatic feature generation.
@property BOOL automatic;
@property(retain, nonatomic) NSString * notes;
@property(assign, nonatomic) NSDictionary *classDict;
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;
- (void) update ;
@end
