//
//  GSElement.h
//  GlyphsCore
//
//  Created by Georg Seifert on 10.04.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief GSElement: The base class for Layer elements.
 \ingroup common
 The base class for Layer elements.
 */

@interface GSElement : NSObject <NSCoding, NSCopying> {
	@public NSPoint	_position;
	id				_parent;
}
/// The position of the element.
@property(assign) NSPoint position;

/// Returns/sets the content of the element to store in pList. 
@property(assign) NSDictionary * elementDict;

/// A Pointer to the containing object
@property(assign) id parent;

/** initialises a element with a dictionary loaded from a pList.

 @param ElementDict A dictionary
 */
- (id) initWithElementDict:(NSDictionary*) ElementDict;
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;
//- (NSRect) bounds;
//- (void) drawInView:(id) View ;
//- (BOOL) hitTest:(NSPoint) Point ;
@end
