//
//  GSFilterPlugin.h
//  GlyphsCore
//
//  Created by Georg Seifert on 19.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GlyphsFilterProtocol.h"
#import "GSGlyphViewControllerProtocol.h"

@class GSFontMaster;

@interface GSFilterPlugin: NSObject <GlyphsFilter> {
	id<GSGlyphViewControllerProtocol, GSGlyphEditViewControllerProtocol> controller;
	BOOL					checkSelection;
	BOOL					returnValue;
	IBOutlet NSView			*_view;
	
	GSFontMaster			*_fontMaster;
	NSMutableArray			*_layers;
	NSMutableArray			*_shadowLayers;
	BOOL					rerun;
}
@property (assign) id <GSGlyphViewControllerProtocol, GSGlyphEditViewControllerProtocol> controller;

- (void) cancelDialog:(id)sender ;
- (void) process:(id) sender ;
- (NSError*) setup ;
- (void) final ;

- (BOOL) runFilterWithLayer:(GSLayer*) Layer error: (NSError**) error ;
- (BOOL) runFilterWithLayers:(NSArray*) Layers error: (NSError**) error ;
@end
