//
//  GSGlyphViewProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 26.01.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
typedef enum {
	GSTopLeft,
	GSTopCenter,
	GSTopRight,
	GSCenterLeft,
	GSCenterCenter,
	GSCenterRight,
	GSBottomLeft,
	GSBottomCenter,
	GSBottomRight,
} GSAlignment;

@class GSLayer;

@protocol GSGlyphEditViewProtocol

@property(assign) GSLayer		*activeLayer;
@property NSPoint				activePosition;
@property NSUInteger			activeIndex;
@property(readonly) NSUInteger	cachedCount;
@property NSRange				selectedRange;
@property(readonly) NSRange		cachedSelectionRange;
@property CGFloat				scale;
@property(retain) NSCursor		*cursor;
@property(assign) GSLayer		*shadowLayer;

- (NSPoint) getActiveLocation:(NSEvent *)theEvent ;
- (GSLayer*) cachedGlyphAtIndex:(NSUInteger)Index ;
- (NSPoint) cachedPositionAtIndex: (NSUInteger)Index ;
- (NSUInteger) characterIndexForPoint:(NSPoint)thePoint ;
- (void) drawLayer:(GSLayer *) Layer atPoint:(NSPoint) aPoint asActive:(BOOL) Active attributes:(NSDictionary*) Attributes ;
- (void) drawText:(NSString*) Text atPoint:(NSPoint) Position withColor:(NSColor*) TextColor ;
//- (void) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (GSAlignment) Alignment ;
- (void) drawBadge:(NSString*) Text atPoint:(NSPoint) DrawPoint alignment: (int) Alignment ;
- (void) reflow;
@end
