//
//  GSGlyphInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief GSGlyphInfo: The class defining the glyphinfo object
 \ingroup common
 This class defines the glyphinfo object.
 */
@interface GSGlyphInfo : NSObject <NSCopying> {
@public
	NSString * name;
	NSString * category;
	NSString * subCategory;
	NSArray * components;
	NSArray * accents;
	NSArray * anchors;
	NSString * unicode;
	NSString * unicode2;
	NSString * script;
	NSString * legacy;
	NSUInteger index;
	NSString * sortName;
}
//! The glyph name.
@property(retain) NSString * name;
//! The category of the glyph.
/**
 This is mostly from the \a UnicodeData.txt file from unicode.org. Some corrections have been made (Accents, ...)
 e.g: "Letter", "Number", "Punctuation", "Mark", "Separator", "Symbol", "Other"
 */
@property(retain) NSString * category;

//! The subcategory of the glyph.
/**
 This is mostly from the \a UnicodeData.txt file from unicode.org. Some corrections and additions have been made (Smallcaps, ...)
 e.g: "Uppercase", "Lowercase", "Smallcaps", "Ligature", "Decimal Digit", ...
 */
@property(retain) NSString * subCategory;

//! The Glyph is composed from this glyphs.
/**
 f_f_i > f f i
 Adieresis > A dieresis
 */
@property(retain) NSArray * components;

//! The Glyph can ba combined with this accents.
/**
 a > dieresis, grave, acute ... 
 */
@property(retain) NSArray * accents;

//! The anchors of the glyph.
/**
 e.g: "top", "ogonek"
 */
@property(retain, nonatomic) NSArray * anchors;

//! The unicode value.
/**
 as a hex string.
 */
@property(retain) NSString * unicode;
//! The second unicode value.
/**
 as a hex string.
 */
@property(retain) NSString * unicode2;

//! The script.
/**
 e.g: "Latin", "Cyrillic", "Greek"
 */
@property(retain) NSString * script;

//! Name to use on export
/**
 acyrill > afii10065
 */
@property(retain) NSString * legacy;
@property NSUInteger index;
@property (nonatomic, retain) NSString *sortName;
- (NSString*) componentsString;
@end
