//
//  GSInstance.h
//  Glyphs
//
//  Created by Georg Seifert on 5.2.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSFont;
/** The class defining the instance object
 */

@interface GSInstance : NSObject <NSCoding, NSCopying> {
	GSFont		*_font;
	NSString	*_name;
	NSString	*_linkStyle;
	float		_interpolationWeight;
	float		_interpolationWidth;
	float		_interpolationCustom;
	NSString	*_weightClass;
	NSString	*_widthClass;
	BOOL		_active;
	BOOL		_isItalic;
	BOOL		_isBold;
	NSMutableDictionary * _instanceInterpolations;
	NSMutableDictionary * tempData;
	NSMutableArray *_customParameters;
}
@property(assign) GSFont *font;
/** The Intances name
 
 This is used as the style name.
 */
@property(copy, nonatomic) NSString* name;
/** The style to use as a the regular for this style.
 
 if styleName is `Medium`, you could link to `Light`. So this instance becomes the Bold stil for the Light.
 */
@property(copy, nonatomic) NSString* linkStyle;
/// The interpolation Weight position.
@property(nonatomic) float interpolationWeight;
/// The interpolation Width position
@property(nonatomic) float interpolationWidth;
/// The interpolation Cutom position
@property(nonatomic) float interpolationCustom;
/** Weight Class
 
 e.g. Regular or Bold
 */
@property (retain, nonatomic) NSString* weightClass;

/** Width Class
 
 e.g. Medium (normal)
 */
@property (retain, nonatomic) NSString* widthClass;

/// If it should be exported.
@property (nonatomic) BOOL active;
/// the Style linking Italic bit
@property (nonatomic) BOOL isItalic;
/// the Style linking Bold bit
@property (nonatomic) BOOL isBold;
@property(retain, nonatomic) NSMutableDictionary * instanceInterpolations;
/// The content of the instance to store it in a pList.
@property(assign) NSDictionary *instanceDict;
@property(retain, nonatomic) NSMutableDictionary *tempData;
@property(retain, nonatomic) NSMutableArray *customParameters;

//- (id) initWithInstance:(GSInstance*) Instance;
- (BOOL) saveToFile:(FILE*) File error:(NSError**) error ;
- (NSArray *)customParameters;
- (NSUInteger)countOfCustomParameters;
- (id) objectInCustomParametersAtIndex:(NSUInteger)theIndex;
- (id) customParameterForKey:(NSString*) Key ;
- (void) getCustomParameters:(id *)objsPtr range:(NSRange)range;
- (void) insertObject:(id)obj inCustomParametersAtIndex:(NSUInteger)theIndex;
- (void) removeObjectFromCustomParametersAtIndex:(NSUInteger)theIndex;
//- (void) addValueToCustomParameters:(id) Value forKey:(NSString*) Key;
- (void) removeObjectFromCustomParametersForKey:(NSString*) Key;

- (void) updateInterpolationValues ;
//- (void)replaceObjectInCustomParametersAtIndex:(NSUInteger)theIndex withObject:(id)obj;


@end
