//
//  GSSubstitution.h
//  Glyphs
//
//  Created by Georg Seifert on 9.9.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface GSSubstitution : NSObject <NSCoding, NSCopying> {
	NSString * _back;
	NSString * _source;
	NSString * _fwd;
	NSString * _target;
	NSString * _backString;
	NSString * _sourceString;
	NSString * _fwdString;
	NSString * _targetString;
	BOOL _ignore;
	NSString * _languageTag;
	NSString * _scriptTag;
}
//! Context glyphs (as glyph names) before the source.
/*
 As glyph names.
 */
@property(retain) NSString* back;
//! The source  glyphs.
/*
 As glyph names.
 */

@property(retain) NSString* source;
//! Context glyphs after the source.
/*
 As glyph names.
 */

@property(retain) NSString* fwd;
//! The target glyphs.
/*
 As glyph names.
 */
@property(retain) NSString* target;
// Context glyphs before the source.
/*
 As char string. This is set internaly.
 */
@property(retain) NSString* backString;
// The source glyphs.
/*
 As char string. This is set internaly.
 */
@property(retain) NSString* sourceString;
// Context glyphs after the source.
/*
 As char string. This is set internaly.
 */
@property(retain) NSString* fwdString;
// The target glyphs.
/*
 As char string. This is set internaly.
 */
@property(retain) NSString* targetString;

//! ignore this substitution.
@property		BOOL ignore;
//! the language tag.
@property(retain) NSString * languageTag;
@property(retain) NSString * scriptTag;
//! Init with dictionary loaded from pList.
- (id) initWithDict:(NSDictionary *) Dict ;
//! Init with String in OT syntax.
- (id) initWithCode:(NSString*) Code ;
//! Returns a dictionary to store in pList.
//- (GSSubstitution*) substitutionForFont:(GSFont*) Font source:(NSString*) Source target:(NSString*) Target ;
- (NSDictionary *) substDict ;
//! The substitution representation on FDK syntax.
- (NSString*) code ;
- (NSString*) code_;
@end
