//
//  GlyphsFileFormatProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.05.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSLayer;

/*! \brief GlyphsFilter: The protocol defining the filter plugin interface
 \ingroup common
 The protocol defining the filter plugin interface.
 */
@protocol GlyphsFilter
/** The interface version.*/
@property (readonly) NSUInteger interfaceVersion;
/** The title of the plugin.*/
@property (readonly) NSString *title;
/** The keyEquivalent to select the Filter.*/
@property (readonly) NSString *keyEquivalent;
/** the Controller of type GSEditViewController */
@property (assign) id controller;
//! is set, if the user choos "run last Filter". Then it should keep the settings from the last run.
@property			BOOL rerun;


- (BOOL) runFilterWithLayer:(GSLayer*) Layer error: (NSError**) error ;
- (BOOL) runFilterWithLayers:(NSArray*) Layers error: (NSError**) error ;
@optional
- (NSString*) actionName ;
@end
