//
//  GlyphsPaletteProtocol.h
//  PalettePlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSNode.h"
#import "GSGlyph.h"
#import "GSPath.h"

/*! \brief GlyphsPalette: The protocol defining the palette plugin interface
 \ingroup common
 The protocol defining the palette plugin interface.
 */
@protocol GlyphsPalette
//! The interface version.
@property (readonly) NSUInteger interfaceVersion;
//! The title of the plugin.
@property (readonly) NSString * title;
//! the view to display in the palette.
@property (readonly) NSView * theView;
//! the minimal height of the view.
@property (readonly) NSInteger minHeight;
//! the maximal height of the view.
@property (readonly) NSInteger maxHeight;


@end