//
//  GlyphsReporterProtocol.h
//  GlyphsReporter
//
//  Created by Georg Seifert on 9.1.12.
//  Copyright 2012 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/*! \brief GlyphsReporter: The protocol defining the reporter plugin protocol
 \ingroup common
 The Tool will show in the View menu and can be enabled like other view settings. It has no functionallity other then draw somthing in the active layer.
 */
@class GSEditViewController;
@class GSLayer;

@protocol GlyphsReporter

//! The interface version.
- (NSUInteger) interfaceVersion;
//! The title of the plugin.
- (NSString*) title;
- (void) setController:(GSEditViewController*) Controller;
- (void) drawBackgroundForLayer:(GSLayer *) Layer ;//scale:(float) Scale;
- (void) drawForgroundForLayer:(GSLayer *) Layer ;//scale:(float) Scale;

@optional
- (void) willActivate;
- (void) willDeactivate;
- (NSString *) keyEquivalent ;
- (int) modifierMask ;	
@end
