//
//  GlyphsToolProtocol.h
//  TestToolPlugin
//
//  Created by Georg Seifert on 4.7.07.
//  Copyright 2007 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSNode.h"
#import "GSGlyph.h"
#import "GSPath.h"
#import "GSInspectorViewController.h"
//@class GSPlainGlyph;
@class GSWindowController;
/*! \brief GlyphsToolDraw: The protocol defining the tool draw plugin protocol
 \ingroup common
 The protocol defining the tool draw plugin protocol.
 Some tool have its own drawing routines. If so, you need to conform to this protocol. If not the last active "drawing" tool will be used.
 \sa GlyphsToolEvent 
 */

#define CLICK_TOLERANCE	4.0

@protocol GlyphsToolDraw

//! The interface version.
@property(readonly) NSUInteger interfaceVersion;
//! The title of the plugin.
@property(readonly) NSString * title;

//! The keydown handler.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) keyDown:(NSEvent *) theEvent;

//! Informs that the mouse has moved.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseMoved:(NSEvent *) theEvent;

//! Informs that the user has pressed the left mouse button.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseDown:(NSEvent *) theEvent;

//! Informs that the user has moved the mouse with the left button pressed.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseDragged:(NSEvent *) theEvent;

//! Informs the receiver that the user has released the left mouse button.
/**
 @param theEvent The event resulting from the user action.
 */
//- (void) mouseUp:(NSEvent *) theEvent;

- (void) modifierChanged:(NSEvent *)anEvent ;
//! delegate method to prevent the selection of a temporaray tool.
- (BOOL) willSelectTempTool:(id) tempTool ;

//! Draws the forground for the Layer. 
/**
 This should be only additional items, as the actual glyph is drawn by the layer plugin.
 @param PlainGlyph The actual GSPlainGlyph instance.
 */
- (void) drawLayer:(GSLayer *) Layer atPoint:(NSPoint) Point asActive:(BOOL) Active attributes:(NSDictionary*) Attributes ;
@optional

//! Draws some genaeral thing to the backgrund of the edit view.
/**
 This should be only additional items, as the actual glyph is drawn by the layer plugin.
 */
- (void) drawBackground ;
- (void) drawForground ;

//! Draws the background for the Layer. 
/**
 This should be only additional items, as the actual glyph is drawn by the layer plugin.
 @param PlainGlyph The actual GSPlainGlyph instance.
 */
- (void) drawBackgroundForLayer:(GSLayer *) Layer ;//scale:(float) Scale;
- (void) drawForgroundForLayer:(GSLayer *) Layer ;//scale:(float) Scale;

//- (void) drawCaretAtIndex:(NSUInteger) Index ;

- (void) willActivate;
- (void) willDeactivate;

//! Copy'n'Past Support
/**
 called from the active tool instance
 **/
//- (void) copy:(id)sender ;
//! Copy'n'Past Support
/**
 called from the active tool instance
 **/
//- (void) paste:(id)sender ;

@optional
//! returnes the view to place in the inpector
- (id) inspectorViewController;

@end
