//
//  InspectorViewGlyphController.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSInspectorViewController.h"
@class GSLayer;

@interface InspectorViewGlyphController : GSInspectorViewController {
	GSLayer * _previousLayer;
	GSLayer * _nextLayer;
	IBOutlet NSButton *leftExeptionButton;
	IBOutlet NSButton *rightExeptionButton;
	IBOutlet NSTextField *nameField;
	IBOutlet NSTextField *unicodeField;
	IBOutlet NSTextField *leftMetricsField;
	IBOutlet NSTextField *widthField;
	IBOutlet NSTextField *rightMetricsField;
	IBOutlet NSTextField *leftKerningField;
	IBOutlet NSTextField *leftGroupField;
	IBOutlet NSTextField *rightGroupField;
	IBOutlet NSTextField *rightKerningField;
	IBOutlet NSButton *showInUnicodeCheckerButton;
	NSImage * exeption;
	NSImage * noExeption;
	NSImage * rightTransferValue;
	NSImage * leftTransferValue;
}

@property(assign) GSLayer * previousLayer;
@property(assign) GSLayer * nextLayer;

- (IBAction) showInUnicodeChecker:(id)sender ;
- (void) setAlternateButtons:(NSNotification*) theNotifivation;

- (IBAction) setName:(id) sender ;
- (IBAction) setLeftMetricsKey:(id) sender ;
- (IBAction) setRightMetricsKey:(id) sender ;
- (IBAction) setWidth:(id) sender ;
- (IBAction) setLeftKerning:(id) sender ;
- (IBAction) setLeftGroup:(id) sender ;
- (IBAction) setLeftExeption:(id) sender ;
- (IBAction) setRightKerning:(id) sender ;
- (IBAction) setRightGroup:(id) sender ;
- (IBAction) setRightExeption:(id) sender ;

@end
