//
//  OTBase.h
//  GSFontTools
//
//  Created by Georg Seifert on 26.07.11.
//  Copyright 2011 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "TTable.h"
//@class MGOrderedDictionary;
@class TableStack;
@class ValueRecord;

@interface OTTableReader : NSObject {
	NSData * _data;
	NSString* _tableType;
	NSUInteger _offset;
	NSUInteger _pos;
	id _valueFormat;
	id _cachingStats;
}
@property (readonly, nonatomic) NSData * data;
@property (nonatomic) NSUInteger pos;
@property (nonatomic) NSUInteger offset;

- (id) initWithData:(NSData *)Data tableTag:(NSString*)TableType ;
- (id) initWithData:(NSData *)Data tableTag:(NSString*)TableType offset:(NSUInteger) Offset valueFormat:(id)ValueFormat cachingStats:(id)CachingStats ;
- (NSString*) tableType ;
- (OTTableReader*) subReader:(NSUInteger) Offset;
- (uint16_t) readUShort ;
- (int16_t) readShort ;
- (uint32_t) readULong ;
- (int32_t) readLong ;
- (NSString*) readTag ;
- (void) setValueFormat:(NSUInteger)format whith:(id)which ;
- (ValueRecord*) valueRecord:(id) Which font:(TTFont*) Font ;
@end

@interface OTTableWriter : NSObject {
	NSMutableDictionary * _items;
	id _tableType;
	NSMutableArray * _valueFormat;
	NSUInteger _pos;
}
@end

@interface TableStack :NSObject {
	NSMutableArray* _stack;
}
@property (readonly, nonatomic) NSArray* stack;

- (void) push:(NSDictionary*) Table ;
- (void) pop ;
- (NSDictionary*) top ;
- (id) getValue:(NSString*) Name ;
- (void) storeValue:(id) Value forKey:(NSString*) Name ;

- (NSDictionary*) _findTable:(NSString*) Name;
@end

@interface OTBaseTable : NSObject {
	NSUInteger _compileStatus;
	NSUInteger _recurse;
	OTTableReader * _reader;
	TTFont * _font;
	NSMutableArray * _converters;
	//NSMutableDictionary * _converterByName;
	NSMutableDictionary * __rawTable;
	NSInteger _format;
	NSString * _name;	
}

@property (readonly, nonatomic) NSArray * converters;
@property (nonatomic) NSInteger format;
@property (retain, nonatomic) NSString * name;
@property (nonatomic) NSUInteger compileStatus;
@property (retain, nonatomic) OTTableReader * reader;
@property (retain, nonatomic) TTFont * font;


//- (BOOL) decompile:(OTTableReader*)Reader font:(TTFont*)Font error:(NSError**)error;
- (Class) lookupListClass ;
- (BOOL) decompile:(OTTableReader *)Reader font:(TTFont *)Font tableStack:(TableStack*) aTableStack error:(NSError**) error ;
- (void) compile:(OTTableWriter*)Writer font:(TTFont*) Font tableStack:(TableStack*) aTableStack ;
- (void) readFormat:(OTTableReader*) Reader ;
- (void) writeFormat:(OTTableWriter*) Writer ;
- (void) postRead:(NSDictionary*) Table font:(TTFont*) Font ;
- (NSDictionary*) preWrite:(TTFont*) Font ;	
//- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font attrs:(id) Attrs; 
- (void) toXML2:(GSXMLWriter*)Writer font:(TTFont*)Font; 
- (void) fromXML:(NSString*)name attrs:(NSDictionary*) attrs content:(id)content font:(TTFont*) Font ;
@end


@interface BaseTTXConverter : TTable {
	//NSString * _tableTag;
	OTBaseTable * _table;
}
@property (retain, nonatomic) OTBaseTable * table;
@end


@interface FormatSwitchingBaseTable : OTBaseTable {
	//NSUInteger _format;
}
//@property (nonatomic) NSUInteger format;
@end


@interface ValueRecordFactory : NSObject {
	NSMutableArray * _format;
}
- (void) setFormat:(unsigned short) ValueFormat;

@end


@interface ValueRecord : NSObject {
	NSInteger xPlacement;
	NSInteger yPlacement;
	NSInteger xAdvance;
	NSInteger yAdvance;
}
@property (nonatomic) NSInteger xPlacement;
@property (nonatomic) NSInteger yPlacement;
@property (nonatomic) NSInteger xAdvance;
@property (nonatomic) NSInteger yAdvance;

@end
@interface valueRecordFormat : NSObject {
@public
	uint16_t Mask;
	NSString * Name;
	BOOL isDevice;
	BOOL isSigned;
}
@end
