// otData

/*
 common (generated from chapter2.htm)
 */
#import "OTBase.h"
#import "OTTables.h"

@interface LookupOrder : OTBaseTable {}
/*
 Dummy class; this table isn't defined, but is used, and is always NULL.
 */
@end
@interface FeatureParams : OTBaseTable {}
@end

@interface OTScriptList : OTBaseTable {
@public
	uint16_t _scriptCount; // Number of ScriptRecords
	NSArray * _scriptRecords; // Array of ScriptRecords -listed alphabetically by ScriptTag
}
@property (nonatomic) uint16_t scriptCount; // Number of ScriptRecords
@property (retain, nonatomic) NSArray * scriptRecords; // Array of ScriptRecords -listed alphabetically by ScriptTag


@end

@class Script;

@interface OTScriptRecord : OTBaseTable {
	Script * _script;
	NSString * _scriptTag; // 4-byte ScriptTag identifier
	NSUInteger _scriptOffsets; //Offset to Script table-from beginning of ScriptList
}
@property (retain, nonatomic) Script * script;
@property (retain, nonatomic) NSString * scriptTag;
@end

@class OTLangSys;

@interface Script : OTBaseTable {
@public
	OTLangSys * _defaultLangSys;
	NSUInteger _defaultLangSysOffsets; //Offset to DefaultLangSys table-from beginning of Script table-may be NULL
	uint16_t _langSysCount; //Number of LangSysRecords for this script-excluding the DefaultLangSys
	NSArray * _langSysRecords; //Array of LangSysRecords-listed alphabetically by LangSysTag
}
@property (retain, nonatomic) OTLangSys * defaultLangSys;
@property (nonatomic) NSUInteger defaultLangSysOffsets; //Offset to DefaultLangSys table-from beginning of Script table-may be NULL
@property (nonatomic) uint16_t langSysCount; //Number of LangSysRecords for this script-excluding the DefaultLangSys
@property (retain, nonatomic) NSArray * langSysRecords; //Array of LangSysRecords-listed alphabetically by LangSysTag


@end

@class OTLangSys;

@interface LangSysRecord : OTBaseTable {

	NSString * _langSysTag; //4-byte LangSysTag identifier
	OTLangSys * _langSys; 
	NSUInteger _langSysOffset; //Offset to LangSys table-from beginning of Script table
}
@property (retain, nonatomic) NSString * langSysTag; //4-byte LangSysTag identifier
@property (retain, nonatomic) OTLangSys * langSys;
@property (nonatomic) NSUInteger langSysOffset; //Offset to LangSys table-from beginning of Script table

@end


@interface OTLangSys : OTBaseTable {
	NSArray * _lookupOrder;
	NSUInteger _lookupOrderOffsets; //= NULL (reserved for an offset to a reordering table)
	uint16_t _reqFeatureIndex; //Index of a feature required for this language system- if no required features = 0xFFFF
	uint16_t _featureCount; //Number of FeatureIndex values for this language system-excludes the required feature
	NSIndexSet * _featureIndexes; //??? vielleicht NSIndexSet // Array of indices into the FeatureList-in arbitrary order 
}
@property (retain, nonatomic) NSArray * lookupOrder;
@property (nonatomic) uint16_t reqFeatureIndex;
@property (nonatomic) uint16_t featureCount;
@property (retain, nonatomic) NSIndexSet * featureIndexes;

@end


@interface OTFeatureList : OTBaseTable {
@public
	uint16_t _featureCount; //Number of FeatureRecords in this table
	NSArray * _featureRecords; //Array of FeatureRecords-zero-based (first feature has FeatureIndex = 0)-listed alphabetically by FeatureTag
}
@property (nonatomic) uint16_t featureCount;
@property (retain, nonatomic) NSArray * featureRecords;

@end

@class Feature;

@interface FeatureRecord : OTBaseTable {
	NSString * _featureTag; //4-byte feature identification tag
	NSUInteger _featureOffsets; //Offset to Feature table-from beginning of FeatureList
	Feature * _feature;
}
@property (retain, nonatomic) NSString * featureTag;
@property (retain, nonatomic) Feature * feature;

@end

@interface Feature : OTBaseTable {
	NSUInteger _featureParamsOffsets; //= NULL (reserved for offset to FeatureParams)
	uint16_t _lookupCount; //Number of LookupList indices for this feature
	NSArray * _lookupListIndexes; //Array of LookupList indices for this feature -zero-based (first lookup is LookupListIndex = 0)
}
@property (nonatomic) NSUInteger featureParamsOffsets;
@property (nonatomic) uint16_t lookupCount;
@property (retain, nonatomic) NSArray * lookupListIndexes;

@end

@class OTLookup;

@interface LookupList : OTBaseTable {
	NSArray * _lookups;
	NSUInteger _lookupCount; //Number of lookups in this table
	NSArray * _lookupOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@property (nonatomic) NSUInteger lookupCount;
@property (retain, nonatomic) NSArray * lookups;

@end


@interface OTLookup : OTBaseTable {
	NSArray * _subTables;
	NSUInteger _lookupType; //Different enumerations for GSUB and GPOS
	NSUInteger _lookupFlag; //Lookup qualifiers
	NSUInteger _subTableCount; //Number of SubTables for this lookup
	NSArray * _subTableOffsets; //Array of offsets to SubTables-from beginning of Lookup table
}
@property (nonatomic) NSUInteger lookupType;
@property (nonatomic) NSUInteger lookupFlag;
@property (nonatomic) NSUInteger subTableCount;
@property (retain, nonatomic) NSArray * subTables;

@end

@interface OTCoverage : FormatSwitchingBaseTable {
	NSMutableArray * _glyphs;
	uint16_t _glyphCount; //Number of glyphs in the GlyphArray
	NSArray * GlyphIDs; //Array of GlyphIDs-in numerical order
	uint16_t _rangeCount; //Number of RangeRecords
	NSArray * _rangeRecords; //Array of glyph ranges-ordered by Start GlyphID
}
@property (retain, nonatomic) NSMutableArray * glyphs;
@end

//@interface CoverageFormat1 : Coverage {
//@public
//	uint16_t GlyphCount; //Number of glyphs in the GlyphArray
//	NSArray * GlyphIDs; //Array of GlyphIDs-in numerical order
//}
//@end
//
//
//@interface CoverageFormat2 : Coverage {
//@public
//	uint16_t RangeCount; //Number of RangeRecords
//	NSArray * RangeRecordss; //Array of glyph ranges-ordered by Start GlyphID
//}
//@end


@interface RangeRecord : OTBaseTable {
@public
	//NSUInteger Start; //First GlyphID in the range
	//NSUInteger End; //Last GlyphID in the range
	// The usage shows that it returnes strings
	NSString * _start; //First GlyphID in the range
	NSString * _end; //Last GlyphID in the range

	//NSRange Range; // vielleicht range benutzen???
	uint16_t _startCoverageIndex; //Coverage Index of first GlyphID in range
}
@end

@interface OTClassDef : FormatSwitchingBaseTable {
	NSDictionary * _classDefs;
	
	NSUInteger StartGlyph; //First GlyphID of the ClassValueArray
	uint16_t GlyphCount; //Size of the ClassValueArray
	NSArray * ClassValues; //Array of Class Values-one per GlyphID

	uint16_t ClassRangeCount; //Number of ClassRangeRecords
	NSArray * ClassRangeRecords; //Array of ClassRangeRecords-ordered by Start GlyphID

	
}
@property (retain, nonatomic) NSDictionary * classDefs;
@end


//@interface ClassDefFormat1 : ClassDef {
//@public
//	
//	NSUInteger StartGlyph; //First GlyphID of the ClassValueArray
//	uint16_t GlyphCount; //Size of the ClassValueArray
//	NSArray * ClassValues; //Array of Class Values-one per GlyphID
//}
//@end
//
//
//@interface ClassDefFormat2 : ClassDef {
//@public
//	uint16_t ClassRangeCount; //Number of ClassRangeRecords
//	NSArray * ClassRangeRecords; //Array of ClassRangeRecords-ordered by Start GlyphID
//}
//@end


@interface ClassRangeRecord : OTBaseTable {
@public
	//NSUInteger Start; //First GlyphID in the range
	//NSUInteger End; //Last GlyphID in the range
	// The usage shows that it returnes strings
	NSString * _start; //First Glyph in the range
	NSString * _end; //Last Glyph in the range

	uint16_t _classID; //Applied to all glyphs in the range
}
@property (nonatomic, retain) NSString *start;
@property (nonatomic, retain) NSString *end;
@property (nonatomic, assign) uint16_t classID;
@end


@interface Device : OTBaseTable {
@public
	uint16_t StartSize; //Smallest size to correct-in ppem
	uint16_t EndSize; //Largest size to correct-in ppem
	uint16_t DeltaFormat; //Format of DeltaValue array data: 1, 2, or 3
	NSArray * DeltaValues; //Array of compressed data
}
@end
/*
	//
	// gpos (generated from gpos.htm)
	//

@interface GPOS : OTBaseTable {
@public
	Fixed Version; //Version of the GPOS table-initially = 0x00010000
	NSUInteger ScriptListOffsets; //Offset to ScriptList table-from beginning of GPOS table
	NSUInteger FeatureListOffsets; //Offset to FeatureList table-from beginning of GPOS table
	NSUInteger LookupListOffsets; //Offset to LookupList table-from beginning of GPOS table
}
@end

@interface SinglePos : FormatSwitchingBaseTable {}
@end
@interface SinglePosFormat1 : SinglePos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of SinglePos subtable
	uint16_t ValueFormat; //Defines the types of data in the ValueRecord
	ValueRecord * Value; //Defines positioning value(s)-applied to all glyphs in the Coverage table
}
@end


@interface SinglePosFormat2 : SinglePos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of SinglePos subtable
	uint16_t ValueFormat; //Defines the types of data in the ValueRecord
	uint16_t ValueCount; //Number of ValueRecords
	NSArray * ValueRecord; //Array of ValueRecords-positioning values applied to glyphs
}
@end

@interface PairPos : FormatSwitchingBaseTable {}
@end
@interface PairPosFormat1 : PairPos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of PairPos subtable-only the first glyph in each pair
	uint16_t ValueFormat1; //Defines the types of data in ValueRecord1-for the first glyph in the pair -may be zero (0)
	uint16_t ValueFormat2; //Defines the types of data in ValueRecord2-for the second glyph in the pair -may be zero (0)
	uint16_t PairSetCount; //Number of PairSet tables
	NSArray * PairSetOffsets; //Array of offsets to PairSet tables-from beginning of PairPos subtable-ordered by Coverage Index
}
@end

@interface PairPosFormat2 : PairPos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of PairPos subtable-for the first glyph of the pair
	uint16_t ValueFormat1; //ValueRecord definition-for the first glyph of the pair-may be zero (0)
	uint16_t ValueFormat2; //ValueRecord definition-for the second glyph of the pair-may be zero (0)
	NSUInteger OffsetClassDef1; //Offset to ClassDef table-from beginning of PairPos subtable-for the first glyph of the pair
	NSUInteger OffsetClassDef2; //Offset to ClassDef table-from beginning of PairPos subtable-for the second glyph of the pair
	uint16_t Class1Count; //Number of classes in ClassDef1 table-includes Class0
	uint16_t Class2Count; //Number of classes in ClassDef2 table-includes Class0
	NSArray * Class1Records; //Array of Class1 records-ordered by Class1
}
@end

@interface PairSet : OTBaseTable {
@public
	uint16_t PairValueCount; //Number of PairValueRecords
	NSArray * PairValueRecords; //Array of PairValueRecords-ordered by GlyphID of the second glyph
}
@end


@interface PairValueRecord : OTBaseTable {
@public
	NSUInteger SecondGlyph; //GlyphID of second glyph in the pair-first glyph is listed in the Coverage table
	ValueRecord * Value1; //Positioning data for the first glyph in the pair
	ValueRecord * Value2; //Positioning data for the second glyph in the pair
}
@end


@interface Class1Record : OTBaseTable {
@public
	NSArray * Class2Records; //Array of Class2 records-ordered by Class2
}
@end


@interface Class2Record : OTBaseTable {
@public
	ValueRecord * Value1; //Positioning for first glyph-empty if ValueFormat1 = 0
	ValueRecord * Value2; //Positioning for second glyph-empty if ValueFormat2 = 0
}
@end

@interface CursivePos : FormatSwitchingBaseTable {}
@end

@interface CursivePosFormat1 : CursivePos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of CursivePos subtable
	uint16_t EntryExitCount; //Number of EntryExit records
	NSArray * EntryExitRecords; //Array of EntryExit records-in Coverage Index order
}
@end

@interface EntryExitRecord : OTBaseTable {
@public
	NSUInteger EntryAnchorOffsets; //Offset to EntryAnchor table-from beginning of CursivePos subtable-may be NULL
	NSUInteger ExitAnchorOffsets; //Offset to ExitAnchor table-from beginning of CursivePos subtable-may be NULL
}
@end


@interface MarkBasePosFormat1 : FormatSwitchingBaseTable {
@public
	NSUInteger MarkCoverageOffsets; //Offset to MarkCoverage table-from beginning of MarkBasePos subtable
	NSUInteger BaseCoverageOffsets; //Offset to BaseCoverage table-from beginning of MarkBasePos subtable
	uint16_t ClassCount; //Number of classes defined for marks
	NSUInteger MarkArrayOffsets; //Offset to MarkArray table-from beginning of MarkBasePos subtable
	NSUInteger BaseArrayOffsets; //Offset to BaseArray table-from beginning of MarkBasePos subtable
}
@end


@interface BaseArray : OTBaseTable {
@public
	uint16_t BaseCount; //Number of BaseRecords
	NSArray * BaseRecords; //Array of BaseRecords-in order of BaseCoverage Index
}
@end


@interface BaseRecord : OTBaseTable {
@public
	NSArray * BaseAnchorOffsets; //Array of offsets (one per class) to Anchor tables-from beginning of BaseArray table-ordered by class-zero-based
}
@end


@interface MarkLigPosFormat1 : FormatSwitchingBaseTable {
@public
	NSUInteger MarkCoverageOffsets; //Offset to Mark Coverage table-from beginning of MarkLigPos subtable
	NSUInteger LigatureCoverageOffsets; //Offset to Ligature Coverage table-from beginning of MarkLigPos subtable
	uint16_t ClassCount; //Number of defined mark classes
	NSUInteger MarkArrayOffsets; //Offset to MarkArray table-from beginning of MarkLigPos subtable
	NSUInteger LigatureArrayOffsets; //Offset to LigatureArray table-from beginning of MarkLigPos subtable
}
@end


@interface LigatureArray : OTBaseTable {
@public
	uint16_t LigatureCount; //Number of LigatureAttach table offsets
	NSArray * LigatureAttachOffsets; //Array of offsets to LigatureAttach tables-from beginning of LigatureArray table-ordered by LigatureCoverage Index
}
@end


@interface LigatureAttach : OTBaseTable {
@public
	uint16_t ComponentCount; //Number of ComponentRecords in this ligature
	NSArray * ComponentRecords; //Array of Component records-ordered in writing direction
}
@end


@interface ComponentRecord : OTBaseTable {
@public
	NSUInteger LigatureAnchorOffsets; //Array of offsets (one per class) to Anchor tables-from beginning of LigatureAttach table-ordered by class-NULL if a component does not have an attachment for a class-zero-based array
}
@end


@interface MarkMarkPosFormat1 : FormatSwitchingBaseTable {
@public
	NSUInteger OffsetMark1Coverage; //Offset to Combining Mark Coverage table-from beginning of MarkMarkPos subtable
	NSUInteger OffsetMark2Coverage; //Offset to Base Mark Coverage table-from beginning of MarkMarkPos subtable
	uint16_t ClassCount; //Number of Combining Mark classes defined
	NSUInteger OffsetMark1Array; //Offset to MarkArray table for Mark1-from beginning of MarkMarkPos subtable
	NSUInteger OffsetMark2Array; //Offset to Mark2Array table for Mark2-from beginning of MarkMarkPos subtable
}
@end


@interface Mark2Array : OTBaseTable {
@public
	uint16_t Mark2Count; //Number of Mark2 records
	NSArray * Mark2Records; //Array of Mark2 records-in Coverage order
}
@end


@interface Mark2Record : OTBaseTable {
@public
	NSArray * Mark2AnchorOffsets; //Array of offsets (one per class) to Anchor tables-from beginning of Mark2Array table-zero-based array
}
@end


@interface PosLookupRecord : OTBaseTable {
@public
	uint16_t SequenceIndex; //Index to input glyph sequence-first glyph = 0
	uint16_t LookupListIndex; //Lookup to apply to that position-zero-based
}
@end

@interface ContextPos : FormatSwitchingBaseTable {}

@interface ContextPosFormat1 : ContextPos {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	uint16_t PosRuleSetCount; //Number of PosRuleSet tables
	NSArray * PosRuleSetOffsets; //Array of offsets to PosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
}
@end


@interface PosRuleSet : OTBaseTable {
@public
	uint16_t PosRuleCount; //Number of PosRule tables
	NSArray * PosRuleOffsets; //Array of offsets to PosRule tables-from beginning of PosRuleSet-ordered by preference
}
@end


@interface PosRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Number of glyphs in the Input glyph sequence
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * InputGlyphIDs; //-1, 'Array of input GlyphIDs-starting with the second glyph
	NSArray * PosLookupRecords; //Array of positioning lookups-in design order
}
@end


@interface ContextPosFormat2 : FormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	NSUInteger ClassDefOffsets; //Offset to ClassDef table-from beginning of ContextPos subtable
	uint16_t PosClassSetCount; //Number of PosClassSet tables
	NSArray * PosClassSetOffsets; //Array of offsets to PosClassSet tables-from beginning of ContextPos subtable-ordered by class-may be NULL
}
@end


@interface PosClassSet : OTBaseTable {
@public
	uint16_t PosClassRuleCount; //Number of PosClassRule tables
	NSArray * PosClassRuleOffsets; //Array of offsets to PosClassRule tables-from beginning of PosClassSet-ordered by preference
}
@end


@interface PosClassRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Number of glyphs to be matched
	uint16_t PosCount; //Number of PosLookupRecords
	uint16_t ClassIDs; //-1, 'Array of classes-beginning with the second class-to be matched to the input glyph sequence
	NSArray * PosLookupRecords; //Array of positioning lookups-in design order
}
@end


@interface ContextPosFormat3 : FormatSwitchingBaseTable {
@public
	uint16_t GlyphCount; //Number of glyphs in the input sequence
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * CoverageOffsets; //Array of offsets to Coverage tables-from beginning of ContextPos subtable
	NSArray * PosLookupRecords; //Array of positioning lookups-in design order
}
@end


@interface ChainContextPosFormat1 : FormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ContextPos subtable
	uint16_t ChainPosRuleSetCount; //Number of ChainPosRuleSet tables
	NSArray * ChainPosRuleSetOffsets; //Array of offsets to ChainPosRuleSet tables-from beginning of ContextPos subtable-ordered by Coverage Index
}
@end


@interface ChainPosRuleSet : OTBaseTable {
@public
	uint16_t ChainPosRuleCount; //Number of ChainPosRule tables
	NSArray * ChainPosRuleOffsets; //Array of offsets to ChainPosRule tables-from beginning of ChainPosRuleSet-ordered by preference
}
@end


@interface ChainPosRule : OTBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * BacktrackGlyphIDs; //Array of backtracking GlyphID's (to be matched before the input sequence)
	uint16_t InputGlyphCount; //Total number of glyphs in the input sequence (includes the first glyph)
	NSArray * InputGlyphIDs; //-1, 'Array of input GlyphIDs (start with second glyph)
	uint16_t LookAheadGlyphCount; //Total number of glyphs in the look ahead sequence (number of glyphs to be matched after the input sequence)
	NSArray * LookAheadGlyphIDs; //Array of lookahead GlyphID's (to be matched after the input sequence)
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * PosLookupRecords; //Array of PosLookupRecords (in design order)
}
@end


@interface ChainContextPosFormat2 : FormatSwitchingBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of ChainContextPos subtable
	NSUInteger BacktrackClassDefOffsets; //Offset to ClassDef table containing backtrack sequence context-from beginning of ChainContextPos subtable
	NSUInteger InputClassDefOffsets; //Offset to ClassDef table containing input sequence context-from beginning of ChainContextPos subtable
	NSUInteger LookAheadClassDefOffsets; //Offset to ClassDef table containing lookahead sequence context-from beginning of ChainContextPos subtable
	uint16_t ChainPosClassSetCount; //Number of ChainPosClassSet tables
	NSArray * ChainPosClassSetOffsets; //Array of offsets to ChainPosClassSet tables-from beginning of ChainContextPos subtable-ordered by input class-may be NULL
}
@end


@interface ChainPosClassSet : OTBaseTable {
@public
	uint16_t ChainPosClassRuleCount; //Number of ChainPosClassRule tables
	NSArray * ChainPosClassRuleOffsets; //Array of offsets to ChainPosClassRule tables-from beginning of ChainPosClassSet-ordered by preference
}
@end


@interface ChainPosClassRule : OTBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * Backtracks; //Array of backtracking classes(to be matched before the input sequence)
	uint16_t InputGlyphCount; //Total number of classes in the input sequence (includes the first class)
	uint16_t Input', 'InputGlyphCount', -1, 'Array of input classes(start with second class; to be matched with the input glyph sequence)
	uint16_t LookAheadGlyphCount; //Total number of classes in the look ahead sequence (number of classes to be matched after the input sequence)
	NSArray * LookAheads; //Array of lookahead classes(to be matched after the input sequence)
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * PosLookupRecords; //Array of PosLookupRecords (in design order)
}
@end


@interface ChainContextPosFormat3 : FormatSwitchingBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	uint16_t InputGlyphCount; //Number of glyphs in input sequence
	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	uint16_t PosCount; //Number of PosLookupRecords
	NSArray * PosLookupRecords; //Array of PosLookupRecords,in design order
}
@end


@interface ExtensionPosFormat1 : FormatSwitchingBaseTable {
@public
	NSUInteger ExtFormat; //Format identifier. Set to 1.
	NSUInteger ExtensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
	LOffset ExtSubTable; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@end


@interface ValueRecord : OTBaseTable {
@public
	int16_t XPlacement; //Horizontal adjustment for placement-in design units
	int16_t YPlacement; //Vertical adjustment for placement-in design units
	int16_t XAdvance; //Horizontal adjustment for advance-in design units (only used for horizontal writing)
	int16_t YAdvance; //Vertical adjustment for advance-in design units (only used for vertical writing)
	NSUInteger XPlaDeviceOffsets; //Offset to Device table for horizontal placement-measured from beginning of PosTable (may be NULL)
	NSUInteger YPlaDeviceOffsets; //Offset to Device table for vertical placement-measured from beginning of PosTable (may be NULL)
	NSUInteger XAdvDeviceOffsets; //Offset to Device table for horizontal advance-measured from beginning of PosTable (may be NULL)
	NSUInteger YAdvDeviceOffsets; //Offset to Device table for vertical advance-measured from beginning of PosTable (may be NULL)
}
@end


@interface AnchorFormat1 : FormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
}
@end


@interface AnchorFormat2 : FormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	uint16_t AnchorPoint; //Index to glyph contour point
}
@end


@interface AnchorFormat3 : FormatSwitchingBaseTable {
@public
	int16_t XCoordinate; //Horizontal value-in design units
	int16_t YCoordinate; //Vertical value-in design units
	NSUInteger XDeviceTableOffsets; //Offset to Device table for X coordinate- from beginning of Anchor table (may be NULL)
	NSUInteger YDeviceTableOffsets; //Offset to Device table for Y coordinate- from beginning of Anchor table (may be NULL)
}
@end


@interface MarkArray : OTBaseTable {
@public
	uint16_t MarkCount; //Number of MarkRecords
	NSArray * MarkRecords; //Array of MarkRecords-in Coverage order
}
@end


@interface MarkRecord : OTBaseTable {
@public
	uint16_t Class; //Class defined for this mark
	NSUInteger MarkAnchorOffsets; //Offset to Anchor table-from beginning of MarkArray table
}
@end

*/

	//
	// gsub (generated from gsub.htm)
	//

@interface GSUB : OTBaseTable {
	OTScriptList * _scriptList;
	LookupList * _lookupList;
	OTFeatureList * _featureList;
	Fixed _version; //Version of the GSUB table-initially set to 0x00010000
	NSUInteger _scriptListOffset; //Offset to ScriptList table-from beginning of GSUB table
	NSUInteger _featureListOffset; //Offset to FeatureList table-from beginning of GSUB table
	NSUInteger _lookupListOffset; //Offset to LookupList table-from beginning of GSUB table
}
@property (retain, nonatomic) OTScriptList * scriptList;
@property (retain, nonatomic) LookupList * lookupList;
@property (retain, nonatomic) OTFeatureList * featureList;
@end

@interface SingleSubst : FormatSwitchingBaseTable {
	NSMutableDictionary * _mapping;
	
	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	int16_t DeltaGlyphID; //Add to original GlyphID to get substitute GlyphID

	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
	NSArray * SubstituteGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage Index

}
@property (readonly, nonatomic) NSDictionary * mapping;
@end

//@interface SingleSubstFormat1 : SingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	int16_t DeltaGlyphID; //Add to original GlyphID to get substitute GlyphID
//}
//@end
//
//
//@interface SingleSubstFormat2 : SingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
//	NSArray * SubstituteGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage Index
//}
//@end

@interface MultipleSubst : FormatSwitchingBaseTable {
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _sequenceCount; //Number of Sequence table offsets in the Sequence array
	NSArray * SequenceOffsets; //Array of offsets to Sequence tables-from beginning of Substitution table-ordered by Coverage Index
	NSArray * _coverage;
	NSArray * _sequences;
}
@property (nonatomic, assign) uint16_t sequenceCount;
@property (nonatomic, retain) NSArray *coverage;
@property (nonatomic, retain) NSArray *sequences;
@end

//@interface MultipleSubstFormat1 : MultipleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t SequenceCount; //Number of Sequence table offsets in the Sequence array
//	NSArray * SequenceOffsets; //Array of offsets to Sequence tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface Sequence : OTBaseTable {
	uint16_t _glyphCount; //Number of GlyphIDs in the Substitute array. This should always be greater than 0.
	NSArray * _substitutes; //String of GlyphIDs to substitute
}
@property (nonatomic, retain) NSArray *substitutes;
@end

@interface OTAlternateSubst : FormatSwitchingBaseTable {
	NSMutableDictionary * _alternates;
	
	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
	uint16_t AlternateSetCount; //Number of AlternateSet tables
	NSArray * AlternateSetOffsets; //Array of offsets to AlternateSet tables-from beginning of Substitution table-ordered by Coverage Index

	
}
@property (retain, nonatomic) NSDictionary * alternates;
@end


//@interface AlternateSubstFormat1 : AlternateSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t AlternateSetCount; //Number of AlternateSet tables
//	NSArray * AlternateSetOffsets; //Array of offsets to AlternateSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface AlternateSet : OTBaseTable {
	NSArray * _alternates;
	uint16_t _glyphCount; //Number of GlyphIDs in the Alternate array
	NSArray * AlternateGlyphIDs; //Array of alternate GlyphIDs-in arbitrary order
}

@property (retain, nonatomic) id alternates;
@end

@interface LigatureSubst : FormatSwitchingBaseTable {
	NSArray * _ligatureSets;
	NSMutableDictionary * _ligatures;
	OTCoverage * _coverage;
	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	uint16_t _ligSetCount; //Number of LigatureSet tables
	NSArray * LigatureSetOffsets; //Array of offsets to LigatureSet tables-from beginning of Substitution table-ordered by Coverage Index

}
@property (retain, nonatomic) NSMutableDictionary * ligatures;
@property (retain, nonatomic) NSArray * ligatureSets;
@end

//@interface LigatureSubstFormat1 : LigatureSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t LigSetCount; //Number of LigatureSet tables
//	NSArray * LigatureSetOffsets; //Array of offsets to LigatureSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface Ligature : OTBaseTable {
@public
	NSString * _ligGlyph; //GlyphName of ligature to substitute
	uint16_t _compCount; //Number of components in the ligature
	NSArray * _components; //-1, 'Array of component Glyph Names-start with the second component-ordered in writing direction
}
@end

@interface LigatureSet : OTBaseTable {
	NSArray * _ligatures;
@public
	uint16_t _ligatureCount; //Number of Ligature tables
	NSArray * LigatureOffsets; //Array of offsets to Ligature tables-from beginning of LigatureSet table-ordered by preference
}
@property (retain, nonatomic) NSArray * ligatures;
@end


@interface SubstLookupRecord : OTBaseTable {
	uint16_t _sequenceIndex; //Index into current glyph sequence-first glyph = 0
	uint16_t _lookupListIndex; //Lookup to apply to that position-zero-based
}
@property (nonatomic, assign) uint16_t sequenceIndex;
@property (nonatomic, assign) uint16_t lookupListIndex;
@end

@interface ContextSubst : FormatSwitchingBaseTable {
	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	uint16_t SubRuleSetCount; //Number of SubRuleSet tables-must equal GlyphCount in Coverage table
	NSArray * SubRuleSetOffsets; //Array of offsets to SubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
	
	NSUInteger ClassDefOffset; //Offset to glyph ClassDef table-from beginning of Substitution table
	uint16_t SubClassSetCount; //Number of SubClassSet tables
	NSArray * SubClassSetOffsets; //Array of offsets to SubClassSet tables-from beginning of Substitution table-ordered by class-may be NULL

	
	uint16_t GlyphCount; //Number of glyphs in the input glyph sequence
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * SubstLookupRecords; //Array of SubstLookupRecords-in design order

}
@end

//@interface ContextSubstFormat1 : ContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t SubRuleSetCount; //Number of SubRuleSet tables-must equal GlyphCount in Coverage table
//	NSArray * SubRuleSetOffsets; //Array of offsets to SubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface SubRuleSet : OTBaseTable {
@public
	uint16_t SubRuleCount; //Number of SubRule tables
	NSArray * SubRuleOffsets; //Array of offsets to SubRule tables-from beginning of SubRuleSet table-ordered by preference
}
@end


@interface SubRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Total number of glyphs in input glyph sequence-includes the first glyph
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * InputGlyphIDs; //-1, 'Array of input GlyphIDs-start with second glyph
	NSArray * SubstLookupRecords; //Array of SubstLookupRecords-in design order
}
@end


//@interface ContextSubstFormat2 : ContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	NSUInteger ClassDefOffsets; //Offset to glyph ClassDef table-from beginning of Substitution table
//	uint16_t SubClassSetCount; //Number of SubClassSet tables
//	NSArray * SubClassSetOffsets; //Array of offsets to SubClassSet tables-from beginning of Substitution table-ordered by class-may be NULL
//}
//@end


@interface SubClassSet : OTBaseTable {
@public
	uint16_t SubClassRuleCount; //Number of SubClassRule tables
	NSArray * SubClassRuleOffsets; //Array of offsets to SubClassRule tables-from beginning of SubClassSet-ordered by preference
}
@end


@interface SubClassRule : OTBaseTable {
@public
	uint16_t GlyphCount; //Total number of classes specified for the context in the rule-includes the first class
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * ClassIds; //-1, 'Array of classes-beginning with the second class-to be matched to the input glyph class sequence
	NSArray * SubstLookupRecords; //Array of Substitution lookups-in design order
}
@end


//@interface ContextSubstFormat3 : ContextSubst {
//@public
//	uint16_t GlyphCount; //Number of glyphs in the input glyph sequence
//	uint16_t SubstCount; //Number of SubstLookupRecords
//	NSArray * CoverageOffsets; //Array of offsets to Coverage table-from beginning of Substitution table-in glyph sequence order
//	NSArray * SubstLookupRecords; //Array of SubstLookupRecords-in design order
//}
//@end


@interface ChainContextSubst : FormatSwitchingBaseTable {
	NSUInteger CoverageOffset; //Offset to Coverage table-from beginning of Substitution table
	uint16_t ChainSubRuleSetCount; //Number of ChainSubRuleSet tables-must equal GlyphCount in Coverage table
	NSArray * ChainSubRuleSetOffsets; //Array of offsets to ChainSubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
	
	NSUInteger BacktrackClassDefOffsets; //Offset to glyph ClassDef table containing backtrack sequence data-from beginning of Substitution table
	NSUInteger InputClassDefOffsets; //Offset to glyph ClassDef table containing input sequence data-from beginning of Substitution table
	NSUInteger LookAheadClassDefOffsets; //Offset to glyph ClassDef table containing lookahead sequence data-from beginning of Substitution table
	uint16_t ChainSubClassSetCount; //Number of ChainSubClassSet tables
	NSArray * ChainSubClassSetOffsets; //Array of offsets to ChainSubClassSet tables-from beginning of Substitution table-ordered by input class-may be NULL

	uint16_t _backtrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	NSArray * _backtrackCoverage;
	uint16_t _inputGlyphCount; //Number of glyphs in input sequence
	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
	NSArray * _inputCoverage;
	uint16_t _lookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	NSArray * _lookAheadCoverage;
	uint16_t _substCount; //Number of SubstLookupRecords
	NSArray * _substLookupRecords; //Array of SubstLookupRecords, in design order

}
@property (nonatomic) uint16_t backtrackGlyphCount;
@property (retain, nonatomic) NSArray * backtrackCoverage;
@property (nonatomic) uint16_t inputGlyphCount;
@property (retain, nonatomic) NSArray * inputCoverage;

@property (nonatomic) uint16_t lookAheadGlyphCount;
@property (retain, nonatomic) NSArray * lookAheadCoverage;


@property (nonatomic) uint16_t substCount;
@property (retain, nonatomic) NSArray * substLookupRecords;
@end

//@interface ChainContextSubstFormat1 : ChainContextSubst {
//@public
//
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	uint16_t ChainSubRuleSetCount; //Number of ChainSubRuleSet tables-must equal GlyphCount in Coverage table
//	NSArray * ChainSubRuleSetOffsets; //Array of offsets to ChainSubRuleSet tables-from beginning of Substitution table-ordered by Coverage Index
//}
//@end


@interface ChainSubRuleSet : OTBaseTable {
@public
	uint16_t ChainSubRuleCount; //Number of ChainSubRule tables
	NSUInteger ChainSubRuleOffsets; //Array of offsets to ChainSubRule tables-from beginning of ChainSubRuleSet table-ordered by preference
}
@end


@interface ChainSubRule : OTBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * BacktrackGlyphIDs; //Array of backtracking GlyphID's (to be matched before the input sequence)
	uint16_t InputGlyphCount; //Total number of glyphs in the input sequence (includes the first glyph)
	NSArray * InputGlyphIDs; //-1, 'Array of input GlyphIDs (start with second glyph)
	uint16_t LookAheadGlyphCount; //Total number of glyphs in the look ahead sequence (number of glyphs to be matched after the input sequence)
	NSArray * LookAheadGlyphIDs; //Array of lookahead GlyphID's (to be matched after the input sequence)
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * SubstLookupRecords; //Array of SubstLookupRecords (in design order)
}
@end


//@interface ChainContextSubstFormat2 : ChainContextSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table-from beginning of Substitution table
//	NSUInteger BacktrackClassDefOffsets; //Offset to glyph ClassDef table containing backtrack sequence data-from beginning of Substitution table
//	NSUInteger InputClassDefOffsets; //Offset to glyph ClassDef table containing input sequence data-from beginning of Substitution table
//	NSUInteger LookAheadClassDefOffsets; //Offset to glyph ClassDef table containing lookahead sequence data-from beginning of Substitution table
//	uint16_t ChainSubClassSetCount; //Number of ChainSubClassSet tables
//	NSArray * ChainSubClassSetOffsets; //Array of offsets to ChainSubClassSet tables-from beginning of Substitution table-ordered by input class-may be NULL
//}
//@end


@interface ChainSubClassSet : OTBaseTable {
@public
	uint16_t ChainSubClassRuleCount; //Number of ChainSubClassRule tables
	NSArray * ChainSubClassRuleOffsets; //Array of offsets to ChainSubClassRule tables-from beginning of ChainSubClassSet-ordered by preference
}
@end


@interface ChainSubClassRule : OTBaseTable {
@public
	uint16_t BacktrackGlyphCount; //Total number of glyphs in the backtrack sequence (number of glyphs to be matched before the first glyph)
	NSArray * Backtracks; //Array of backtracking classes(to be matched before the input sequence)
	uint16_t InputGlyphCount; //Total number of classes in the input sequence (includes the first class)
	NSArray * InputClassIds; //-1, 'Array of input classes(start with second class; to be matched with the input glyph sequence)
	uint16_t LookAheadGlyphCount; //Total number of classes in the look ahead sequence (number of classes to be matched after the input sequence)
	NSArray * LookAheads; //Array of lookahead classes(to be matched after the input sequence)
	uint16_t SubstCount; //Number of SubstLookupRecords
	NSArray * SubstLookupRecords; //Array of SubstLookupRecords (in design order)
}
@end


//@interface ChainContextSubstFormat3 : ChainContextSubst {
//@public
//	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
//	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
//	uint16_t InputGlyphCount; //Number of glyphs in input sequence
//	NSArray * InputCoverageOffsets; //Array of offsets to coverage tables in input sequence, in glyph sequence order
//	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
//	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
//	uint16_t SubstCount; //Number of SubstLookupRecords
//	NSArray * SubstLookupRecords; //Array of SubstLookupRecords, in design order
//}
//@end

@interface ExtensionSubst : FormatSwitchingBaseTable {
	NSUInteger ExtensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
	NSArray * ExtSubTableOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
}
@end


//@interface ExtensionSubstFormat1 : ExtensionSubst {
//@public
//	NSUInteger ExtensionLookupType; //Lookup type of subtable referenced by ExtensionOffset (i.e. the extension subtable).
//	NSArray * ExtSubTableOffsets; //Array of offsets to Lookup tables-from beginning of LookupList -zero based (first lookup is Lookup index = 0)
//}
//@end

@interface ReverseChainSingleSubst : FormatSwitchingBaseTable {
	NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of Substitution table
	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
	NSArray * GlyphCountGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage index
}
@end


//@interface ReverseChainSingleSubstFormat1 : ReverseChainSingleSubst {
//@public
//	NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of Substitution table
//	uint16_t BacktrackGlyphCount; //Number of glyphs in the backtracking sequence
//	NSArray * BacktrackCoverageOffsets; //Array of offsets to coverage tables in backtracking sequence, in glyph sequence order
//	uint16_t LookAheadGlyphCount; //Number of glyphs in lookahead sequence
//	NSArray * LookAheadCoverageOffsets; //Array of offsets to coverage tables in lookahead sequence, in glyph sequence order
//	uint16_t GlyphCount; //Number of GlyphIDs in the Substitute array
//	NSArray * GlyphCountGlyphIDs; //Array of substitute GlyphIDs-ordered by Coverage index
//}
//@end

#pragma mark gdef (generated from gdef.htm)

@interface AttachList : OTBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of AttachList table
	uint16_t GlyphCount; //Number of glyphs with attachment points
	NSArray * AttachPointOffsets; //Array of offsets to AttachPoint tables-from beginning of AttachList table-in Coverage Index order
}
@end

@interface LigCaretList : OTBaseTable {
@public
	NSUInteger CoverageOffsets; //Offset to Coverage table - from beginning of LigCaretList table
	uint16_t LigGlyphCount; //Number of ligature glyphs
	NSArray * LigGlyphOffsets; //Array of offsets to LigGlyph tables-from beginning of LigCaretList table-in Coverage Index order
}
@end

@interface GDEF : OTBaseTable {
	Fixed _version; //Version of the GDEF table-initially 0x00010000
	OTClassDef * _glyphClassDef;
	NSUInteger _glyphClassDefOffset; //Offset to class definition table for glyph type-from beginning of GDEF header (may be NULL)
	AttachList * _attachList;
	NSUInteger AttachListOffsets; //Offset to list of glyphs with attachment points-from beginning of GDEF header (may be NULL)
	LigCaretList * _ligCaretList;
	NSUInteger LigCaretListOffsets; //Offset to list of positioning points for ligature carets-from beginning of GDEF header (may be NULL)
	OTClassDef * _markAttachClassDef;
	NSUInteger MarkAttachClassDefOffsets; //Offset to class definition table for mark attachment type-from beginning of GDEF header (may be NULL)
}
@property (nonatomic, retain) OTClassDef *glyphClassDef;
@property (nonatomic, retain) AttachList *attachList;
@property (nonatomic, retain) LigCaretList *ligCaretList;
@property (nonatomic, retain) OTClassDef *markAttachClassDef;
@end





@interface AttachPoint : OTBaseTable {
@public
	uint16_t PointCount; //Number of attachment points on this glyph
	NSArray * PointIndexs; //Array of contour point indices -in increasing numerical order
}
@end


@interface LigGlyph : OTBaseTable {
@public
	uint16_t CaretCount; //Number of CaretValues for this ligature (components - 1)
	NSArray * CaretValueOffsets; //Array of offsets to CaretValue tables-from beginning of LigGlyph table-in increasing coordinate order
}
@end

@interface CaretValue : FormatSwitchingBaseTable {
@public
	int16_t _coordinate; //X or Y value, in design units
	
	uint16_t CaretValuePoint; //Contour point index on glyph
	
	int16_t Coordinate; //X or Y value, in design units
	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value-from beginning of CaretValue table

}
@property (nonatomic) int16_t coordinate;
@end


//@interface CaretValueFormat1 : CaretValue {
//@public
//	
//}
//@end


//@interface CaretValueFormat2 : CaretValue {
//@public
//	uint16_t CaretValuePoint; //Contour point index on glyph
//}
//@end


//@interface CaretValueFormat3 : CaretValue {
//@public
//	int16_t Coordinate; //X or Y value, in design units
//	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value-from beginning of CaretValue table
//}
//@end

#pragma mark -
#pragma mark base (generated from base.htm)

@interface BASE : OTBaseTable {
@public
	/*fixed32*/ uint32_t Version; //Version of the BASE table-initially 0x00010000
	NSUInteger HorizAxisOffsets; //Offset to horizontal Axis table-from beginning of BASE table-may be NULL
	NSUInteger VertAxisOffsets; //Offset to vertical Axis table-from beginning of BASE table-may be NULL
}
@end


@interface Axis : OTBaseTable {
@public
	NSUInteger BaseTagListOffsets; //Offset to BaseTagList table-from beginning of Axis table-may be NULL
	NSUInteger BaseScriptListOffsets; //Offset to BaseScriptList table-from beginning of Axis table
}
@end


@interface BaseTagList : OTBaseTable {
@public
	uint16_t BaseTagCount; //Number of baseline identification tags in this text direction-may be zero (0)
	NSArray * BaselineTags; //Array of 4-byte baseline identification tags-must be in alphabetical order
}
@end


@interface BaseScriptList : OTBaseTable {
@public
	uint16_t BaseScriptCount; //Number of BaseScriptRecords defined
	NSArray * BaseScriptRecords; //Array of BaseScriptRecords-in alphabetical order by BaseScriptTag
}
@end


@interface BaseScriptRecord : OTBaseTable {
@public
	NSString * BaseScriptTag; //4-byte script identification tag
	NSUInteger BaseScriptOffsets; //Offset to BaseScript table-from beginning of BaseScriptList
}
@end


@interface BaseScript : OTBaseTable {
@public
	NSUInteger BaseValueOffsets; //Offset to BaseValues table-from beginning of BaseScript table-may be NULL
	NSUInteger DefaultMinMaxOffsets; //Offset to MinMax table- from beginning of BaseScript table-may be NULL
	uint16_t BaseLangSysCount; //Number of BaseLangSysRecords defined-may be zero (0)
	NSArray * BaseLangSysRecords; //Array of BaseLangSysRecords-in alphabetical order by BaseLangSysTag
}
@end


@interface BaseLangSysRecord : OTBaseTable {
@public
	NSString * BaseLangSysTag; //4-byte language system identification tag
	NSUInteger MinMaxOffsets; //Offset to MinMax table-from beginning of BaseScript table
}
@end


@interface BaseValues : OTBaseTable {
@public
	uint16_t DefaultIndex; //Index number of default baseline for this script-equals index position of baseline tag in BaselineArray of the BaseTagList
	uint16_t BaseCoordCount; //Number of BaseCoord tables defined-should equal BaseTagCount in the BaseTagList
	NSArray * BaseCoordOffsets; //Array of offsets to BaseCoord-from beginning of BaseValues table-order matches BaselineTag array in the BaseTagList
}
@end


@interface MinMax : OTBaseTable {
@public
	NSUInteger MinCoordOffsets; //Offset to BaseCoord table-defines minimum extent value-from the beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; //Offset to BaseCoord table-defines maximum extent value-from the beginning of MinMax table-may be NULL
	uint16_t FeatMinMaxCount; //Number of FeatMinMaxRecords-may be zero (0)
	NSArray * FeatMinMaxRecords; //Array of FeatMinMaxRecords-in alphabetical order, by FeatureTableTag
}
@end


@interface FeatMinMaxRecord : OTBaseTable {
@public
	NSString * FeatureTableTag; //4-byte feature identification tag-must match FeatureTag in FeatureList
	NSUInteger MinCoordOffsets; //Offset to BaseCoord table-defines minimum extent value-from beginning of MinMax table-may be NULL
	NSUInteger MaxCoordOffsets; //Offset to BaseCoord table-defines maximum extent value-from beginning of MinMax table-may be NULL
}
@end

@interface BaseCoord : FormatSwitchingBaseTable {
	int16_t Coordinate; //X or Y value, in design units
	NSUInteger ReferenceGlyph; //GlyphID of control glyph
	uint16_t BaseCoordPoint; //Index of contour point on the ReferenceGlyph
	
	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value
}
@end

//@interface BaseCoordFormat1 : BaseCoord {}
//@end
//
//
//@interface BaseCoordFormat2 : BaseCoord {
//@public
//	NSUInteger ReferenceGlyph; //GlyphID of control glyph
//	uint16_t BaseCoordPoint; //Index of contour point on the ReferenceGlyph
//}
//@end


//@interface BaseCoordFormat3 : BaseCoord {
//@public
//	NSUInteger DeviceTableOffsets; //Offset to Device table for X or Y value
//}
//@end


#pragma mark -
#pragma mark jstf (generated from jstf.htm)

@interface JSTF : OTBaseTable {
@public
	Fixed /*fixed32*/ Version; //Version of the JSTF table-initially set to 0x00010000
	uint16_t JstfScriptCount; //Number of JstfScriptRecords in this table
	NSArray * JstfScriptRecords; //Array of JstfScriptRecords-in alphabetical order, by JstfScriptTag
}
@end


@interface JstfScriptRecord : OTBaseTable {
@public
	NSString * JstfScriptTag; //4-byte JstfScript identification
	NSUInteger JstfScriptOffsets; //Offset to JstfScript table-from beginning of JSTF Header
}
@end


@interface JstfScript : OTBaseTable {
@public
	NSUInteger ExtenderGlyphOffsets; //Offset to ExtenderGlyph table-from beginning of JstfScript table-may be NULL
	NSUInteger DefJstfLangSysOffsets; //Offset to Default JstfLangSys table-from beginning of JstfScript table-may be NULL
	uint16_t JstfLangSysCount; //Number of JstfLangSysRecords in this table- may be zero (0)
	NSArray * JstfLangSysRecords; //Array of JstfLangSysRecords-in alphabetical order, by JstfLangSysTag
}
@end


@interface JstfLangSysRecord : OTBaseTable {
@public
	NSString * JstfLangSysTag; //4-byte JstfLangSys identifier
	NSUInteger JstfLangSysOffsets; //Offset to JstfLangSys table-from beginning of JstfScript table
}
@end


@interface ExtenderGlyph : OTBaseTable {
@public
	uint16_t GlyphCount; //Number of Extender Glyphs in this script
	NSArray * ExtenderGlyphIDs; //GlyphIDs-in increasing numerical order
}
@end


@interface JstfLangSys : OTBaseTable {
@public
	uint16_t JstfPriorityCount; //Number of JstfPriority tables
	NSArray * JstfPriorityOffsets; //Array of offsets to JstfPriority tables-from beginning of JstfLangSys table-in priority order
}
@end


@interface JstfPriority : OTBaseTable {
@public
	NSUInteger ShrinkageEnableGSUBOffsets; //Offset to Shrinkage Enable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGSUBOffsets; //Offset to Shrinkage Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageEnableGPOSOffsets; //Offset to Shrinkage Enable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageDisableGPOSOffsets; //Offset to Shrinkage Disable JstfGPOSModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ShrinkageJstfMaxOffsets; //Offset to Shrinkage JstfMax table-from beginning of JstfPriority table -may be NULL
	NSUInteger ExtensionEnableGSUBOffsets; //Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGSUBOffsets; //Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionEnableGPOSOffsets; //Offset to Extension Enable JstfGSUBModList table-may be NULL
	NSUInteger ExtensionDisableGPOSOffsets; //Offset to Extension Disable JstfGSUBModList table-from beginning of JstfPriority table-may be NULL
	NSUInteger ExtensionJstfMaxOffsets; //Offset to Extension JstfMax table-from beginning of JstfPriority table -may be NULL
}
@end


@interface JstfGSUBModList : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookups for this modification
	NSArray * GSUBLookupIndexs; //Array of LookupIndex identifiers in GSUB-in increasing numerical order
}
@end


@interface JstfGPOSModList : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookups for this modification
	NSArray * GPOSLookupIndexs; //Array of LookupIndex identifiers in GPOS-in increasing numerical order
}
@end


@interface JstfMax : OTBaseTable {
@public
	uint16_t LookupCount; //Number of lookup Indices for this modification
	NSArray * LookupOffsets; //Array of offsets to GPOS-type lookup tables-from beginning of JstfMax table-in design order
}
@end


NSInteger doModulo(NSInteger value) ;
NSArray * _getGlyphsFromCoverageTable( OTCoverage * coverage) ;

