//
//  GSComponent.h
//  Glyphs
//
//  Created by Georg Seifert on 30.3.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
@class GSGlyph;
@class GSFont;
@class GSLayer;
@class SCEvents;
#import <GlyphsCore/SCEventListenerProtocol.h>
/*! \brief GSComponent: The class defining the component object
 \ingroup common
 This class defines the component object. It is a subclass of GSElement
 */
@interface GSBackgroundImage : GSElement <SCEventListenerProtocol> {
	//NSURL							*imageURL;
	NSString						*imagePath;
	NSImage							*image;
	@public NSAffineTransformStruct transformStruct;
	NSRect							crop;
	BOOL							locked;
	NSDate							*imageFileDate;
	BOOL							didAsk;
	SCEvents*						events;
}

//* @name Initialisation*/
/// Inits with a NSURL 
- (id) initWithURL: (NSURL*) URL ;
/// Inits with a path 
- (id) initWithPath: (NSString*) Path ;

/// the image path
@property(retain, nonatomic) NSString	*imagePath;
/// the NSImage
@property(readonly, nonatomic) NSImage *image ;
/// The Crop
@property(assign)	NSRect	crop;
/// if the image is looked
@property(assign, nonatomic)	BOOL	locked;

/** The transformation of the component.

 The values of the struct are:
 {m11, m12, m21, m22, tX, tY}
 this is equivalent to the glif attributes
 {xScale, xyScale, yxScale, yScale, xOffset, yOffset}
 in the same order.
 The initial value is {1,0,0,1,0,0}.
 */
@property(assign, nonatomic) NSAffineTransformStruct transformStruct;

/// Shows the image in the Finder
- (void) showInFinder:(id) sender ;
/// toggle locked
- (void) toggleLocked ;
- (BOOL) hasImageToDraw;
@end
