//
//  GSGlyphsInfo.h
//  Glyphs
//
//  Created by Georg Seifert on 20.1.08.
//  Copyright 2008 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
@class GSGlyphInfo;
@class GSGlyph;
@class GSFont;
@class GSLayer;
@class MGOrderedDictionary;
/*! \brief GSGlyphsInfos: This is a singlton class to provide glyphinfo services.
 \ingroup common
 This is a singlton class to provide glyphinfo services.
 */
@interface GSGlyphsInfo : NSObject {
	NSMutableArray*				glyphInfos;
	NSMutableArray*				glyphGroupsTree;
	NSMutableArray*				categories;
	NSMutableDictionary*		_name2Group;
	NSMutableDictionary*		name2Info;
	NSMutableDictionary*		unicode2Info;
	NSMutableDictionary*		languages;
	NSMutableArray*				scripts;
	NSDictionary*				anchors; 
	NSDictionary*				_fontInfoProperties;
	NSDictionary*				_basicFontInfoProperties;
//	NSDictionary*				_customInstanceProperties;
//	NSDictionary*				_customMasterProperties;
	IBOutlet NSArrayController	*glyphGroupsTreeTreeController;
	bool						updating;
	MGOrderedDictionary			*commonLigs;
	int							defaultFigures;
	NSDictionary				*widthClasses;
	NSDictionary				*weightClasses;
	NSDictionary				*_scriptAbrevations;
	NSDictionary				*_scriptSuffixes;
	NSDictionary				*_languageScripts;
	NSDictionary				*_nonCombiningFeatures;
	NSArray						*_unicodeRanges;
@private
	NSMutableDictionary			*subGroupCache;
}
/** An array of glyph groups.

 This is used the build the filter tree in font view mode. 
 */
@property(readonly, nonatomic) NSMutableArray *glyphGroupsTree;
@property(readonly, nonatomic) NSMutableArray *categories;
@property(readonly, nonatomic) NSMutableDictionary *name2Group;
/// The array containing the glyphs info data.
@property(retain, nonatomic) NSMutableArray *glyphInfos;
@property(readonly, nonatomic) NSMutableArray *scripts;
@property(readonly, nonatomic) NSDictionary* fontInfoProperties;

//#ifndef GLYPHS_LITE
//@property(readonly, nonatomic) NSDictionary* customMasterProperties;
//@property(readonly, nonatomic) NSDictionary* customInstanceProperties;
//#endif
//
@property(readonly, nonatomic) NSDictionary* basicFontInfoProperties;
@property(readonly, nonatomic) NSMutableDictionary* languages;
/// The widthclasses
@property(readonly, nonatomic) NSDictionary * widthClasses;
/// The weightclasses
@property(readonly, nonatomic) NSDictionary * weightClasses;
@property(readonly, nonatomic) NSDictionary * name2Info;

/// Returns the shared GlyphsInfos object.
+ (GSGlyphsInfo*) sharedManager;
- (void) loadGlyphInfo ;
+ (NSString *) applicationSupportFolder;
- (void) reloadCustomFilterGroup;
- (NSDictionary*) loadCustomFilterGroup;
/** Returns the GSGlyphInfo for the glyph with \a Name.

 @param Name The glyph name.
 @return A GSGlyphInfo instance or nil.
 */
+ (GSGlyphInfo*) glyphInfoForName:(NSString*) Name ;
/** Returns the GSGlyphInfo for the glyph with \a Unicode.

 @param Unicode A \a unicode as Hex string.
 @return A GSGlyphInfo instance or nil.
 */
+ (GSGlyphInfo*) glyphInfoForUnicode:(NSString*) Unicode ;
/// Returnes the index of the glyph in the database.
- (NSUInteger) glyphIndex:(GSGlyph *) Glyph;
/// Updates the glyph info in the \a Glyph.
+ (void) updateGlyphInfo:(GSGlyph *) Glyph ;
+ (void) updateGlyphInfo:(GSGlyph *) Glyph changeName:(BOOL) ChangeName;
/// Generates missing anchors in the Layer.
+ (void) updateAnchor:(GSLayer*) Layer ;
/// Generates the OT features for the \a Font.
- (void) makeFeatures:(GSFont *) Font ;
//- (NSArray*) componentsForGlyph:(NSString *) GlyphsName ;
- (NSDictionary*) fontInfoProperties ;
- (NSDictionary*) basicFontInfoProperties ;
/** converts a name to a standardised name

 e.g. converts afii10017 to A-cy
 */
+ (NSString*) niceGlpyhNameForName: (NSString*) Name;
+ (NSString*) legacyGlpyhNameForName: (NSString*) Name;
+ (void) fixASCIINames: (GSFont*) Font;
+ (NSArray*) compleationsForName: (NSString*) PartialName forPartialWordRange:(NSRange)charRange ;
+ (NSDictionary*) scriptAbrevations;
+ (NSDictionary*) languageScripts;
+ (NSMutableString*) windowsStyle:(GSFont*) Font ;
+ (NSMutableString*) macStyle:(GSFont*) Font ;
- (NSDictionary*) _scriptAbrevations;
- (NSDictionary*) _scriptSuffixes;
+ (NSDictionary*) nonCombiningFeatures;
+ (NSArray*) unicodeRanges;
+ (NSString*) cleanMakeOTFErrormessage:(NSString*) ErrorMessage errorDescriptors:(NSMutableArray*) ErrorDescriptors;

- (void) updateFeatureForTag:(NSString*) Tag forFont:(GSFont*) Font ;
- (void) updateClassForTag:(NSString*) Tag forFont:(GSFont*) Font ;
- (void) updatePrefixForTag:(NSString*) Tag forFont:(GSFont*) Font ;
@end
