//
//  GSGuideLine.h
//  GlyphsCore
//
//  Created by Georg Seifert on 03.02.10.
//  Copyright 2010 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
#import "GSHandle.h"
@class GSLayer;

@interface GSGuideLine : GSElement {
	CGFloat _angle;
	BOOL _leftAligned;
	GSHandle * _handle;
	BOOL _showMeasurement;
	NSArray * _intersections;
}

/** the Angle */
@property (nonatomic) CGFloat angle;
/** Left Aligned */
@property (nonatomic) BOOL leftAligned;
@property (nonatomic, retain) GSHandle *handle;
@property (nonatomic, assign) BOOL showMeasurement;
@property (nonatomic, retain) NSArray *intersections;

- (void) calculateIntersectionsForLayer:(GSLayer*) currLayer ;
@end
