//
//  GSHint.h
//  GlyphsCore
//
//  Created by Georg Seifert on 21.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "GSElement.h"
@class GSNode;

@interface GSHint : GSElement <NSCoding, NSCopying> {

	GSNode					*originNode;
	GSNode					*targetNode;
	NSIndexPath				*originIndex;
	NSIndexPath				*targetIndex;
	NSInteger				ghost;
	NSRect					badgeRect;
	NSPoint					originKnob;
	NSPoint					targetKnob;
	int						selection;
@public
	CGFloat					origin;
	CGFloat					width;
	BOOL					horizontal;
}

@property (nonatomic) CGFloat	origin;
@property (nonatomic) CGFloat	width;
@property BOOL					horizontal;
@property(retain) GSNode		*originNode;
@property(retain) GSNode		*targetNode;
@property(retain) NSIndexPath	*originIndex;
@property(retain) NSIndexPath	*targetIndex;
@property NSInteger				ghost;
@property NSRect				badgeRect;
@property NSPoint				originKnob;
@property NSPoint				targetKnob;
@property int					selection;

- (id) initWithHintDict:(NSDictionary*) HintDict;
- (void) makeGhost;
@end
