//
//  GSSnaper.h
//  GlyphsLayerPluginOutline
//
//  Created by Georg Seifert on 24.01.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class GSNode;

@interface GSSnaper : NSObject {
	NSPoint _from;
	NSPoint _to;
	BOOL _open;
	CGFloat _distance;
	BOOL _required;
}
// The Origin of the Snapper.
@property NSPoint from;
// If it is a line, the second value is set
@property NSPoint to;
@property BOOL open;
@property CGFloat distance;
@property BOOL required;

- (int) compare:(id) element;
- (void) setDistanceToPoint:(NSPoint) Point;
- (NSPoint) nearestPointForPoint:(NSPoint) Point;
@end
