//
//  GlyphsFileFormatProtocol.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.05.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

@class GSFont;
/*! \brief GlyphsFileFormat: The protocol defining the file format plugin interface
 \ingroup common
 The protocol defining the file format plugin interface.
 */
@protocol GlyphsFileFormat
//! The interface version.
@property (readonly) NSUInteger interfaceVersion;
//! The title of the plugin.
@property (readonly) NSString * title;
//! The view to be displayed in the export dialog.
@property (readonly) NSView * exportSettingsView;
//! The GSFont object is assigned the the plugin prior to the export.
/**
 This is used to publish the export dialog.
 */
@property (assign) GSFont * font;

//! Outputs a Font object. 
/**
 This function should ask the user for the place to save the store the font.
 @param Font The font to export.
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return YES if the operation was successful; otherwise, NO.
 */
- (BOOL) writeFont:(GSFont *) Font error:(NSError**)error ;

//! Outputs a Font object to the specified URL.
/**
 @param Font The font to export.
 @param URL The URL to save the font to.
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return YES if the operation was successful; otherwise, NO.
 */
- (BOOL) writeFont:(GSFont*) Font toURL:(NSURL*) URL error: (NSError**) error ;

//! Reads a Font object from the specified URL.
/**
 @param URL The URL to read the font from.
 @param error On return, If the document contents could not be read, a pointer to an error object that encapsulates the reason they could not be read.
 @return The font object, or nil if an error occurred.
 */
- (GSFont*) fontFromURL:(NSURL *) URL error:(NSError**)error ;
- (id) progressWindow ;
- (NSUInteger) groupID ;
@end
